'////////////////////////////////////////////////////////////////////
'/
'/  Name:            QueryPrinters.vbs
'/  Version:         1.0 (4 Sept 2003)
'/  Author:          Eric Wallace (e@ewall.org)
'/  Updates:         http://www.ewall.org/
'/
'/  Description:     queries WMI for printer object info
'/
'////////////////////////////////////////////////////////////////////

On Error Resume Next

'force script to run under command-line version
MakeDesiredHost "cscript.exe"

strComputer = "."
Set objWMIService = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")

Wscript.Echo vbCrLf & "### Win32_Printer Object ###"
Set colItems = objWMIService.ExecQuery("Select * from Win32_Printer",,48)
For Each objItem in colItems
    Wscript.Echo vbCrLf & "NAME: " & objItem.Name
    Wscript.Echo "Default: " & objItem.Default
    Wscript.Echo "Description: " & objItem.Description
    Wscript.Echo "DeviceID: " & objItem.DeviceID
    Wscript.Echo "Direct: " & objItem.Direct
    Wscript.Echo "DriverName: " & objItem.DriverName
    Wscript.Echo "Local: " & objItem.Local
    Wscript.Echo "Network: " & objItem.Network
    Wscript.Echo "PNPDeviceID: " & objItem.PNPDeviceID
    Wscript.Echo "PortName: " & objItem.PortName
    Wscript.Echo "PrintProcessor: " & objItem.PrintProcessor
    Wscript.Echo "RawOnly: " & objItem.RawOnly
    Wscript.Echo "ServerName: " & objItem.ServerName
    Wscript.Echo "Shared: " & objItem.Shared
    Wscript.Echo "ShareName: " & objItem.ShareName
    Wscript.Echo "SpoolEnabled: " & objItem.SpoolEnabled
    Wscript.Echo "SystemName: " & objItem.SystemName
Next

Wscript.Echo vbCrLf & vbCrLf & "### Win32_PrinterConfiguration Object ###"
Set colItems = Nothing
Set colItems = objWMIService.ExecQuery("Select * from Win32_PrinterConfiguration",,48)
For Each objItem in colItems
    Wscript.Echo vbCrLf & "NAME: " & objItem.Name
    Wscript.Echo "Description: " & objItem.Description
    Wscript.Echo "DeviceName: " & objItem.DeviceName
    Wscript.Echo "DriverVersion: " & objItem.DriverVersion
Next

Wscript.Echo vbCrLf & vbCrLf & "### Win32_PrinterDriver Object ###"
Set colItems = Nothing
Set colItems = objWMIService.ExecQuery("Select * from Win32_PrinterDriver",,48)
For Each objItem in colItems
    Wscript.Echo vbCrLf & "NAME: " & objItem.Name
    Wscript.Echo "Caption: " & objItem.Caption
    Wscript.Echo "ConfigFile: " & objItem.ConfigFile
    Wscript.Echo "DataFile: " & objItem.DataFile
    Wscript.Echo "DefaultDataType: " & objItem.DefaultDataType
    Wscript.Echo "DependentFiles: " & objItem.DependentFiles
    Wscript.Echo "Description: " & objItem.Description
    Wscript.Echo "DriverPath: " & objItem.DriverPath
    Wscript.Echo "FilePath: " & objItem.FilePath
    Wscript.Echo "HelpFile: " & objItem.HelpFile
    Wscript.Echo "InfName: " & objItem.InfName
    Wscript.Echo "InstallDate: " & objItem.InstallDate
    Wscript.Echo "MonitorName: " & objItem.MonitorName
    Wscript.Echo "SupportedPlatform: " & objItem.SupportedPlatform
    Wscript.Echo "SystemName: " & objItem.SystemName
    Wscript.Echo "Version: " & objItem.Version
Next

Wscript.Echo vbCrLf & vbCrLf & "### Win32_TCPIPPrinterPort Object ###"
Set colItems = objWMIService.ExecQuery("Select * from Win32_TCPIPPrinterPort",,48)
For Each objItem in colItems
    Wscript.Echo vbCrLf & "NAME: " & objItem.Name
    Wscript.Echo "Caption: " & objItem.Caption
    Wscript.Echo "Description: " & objItem.Description
    Wscript.Echo "HostAddress: " & objItem.HostAddress
    Wscript.Echo "PortNumber: " & objItem.PortNumber
    Wscript.Echo "Protocol: " & objItem.Protocol
    Wscript.Echo "Queue: " & objItem.Queue
    Wscript.Echo "SystemName: " & objItem.SystemName
    Wscript.Echo "Type: " & objItem.Type
Next

Wscript.Quit 0

'MakeDesiredHost subroutine, borrowed from Darwin Sanoy (http://desktopengineer.com/)
Sub MakeDesiredHost(desiredhost)
	g_sScriptEngine = lcase(mid(WScript.FullName, InstrRev(WScript.FullName,"\")+1))
	Dim oShell : Set oShell = createobject("wscript.shell") 
	comspec = oShell.Environment("Process").Item("COMSPEC")
	If Not g_sScriptEngine=desiredhost Then
		' re-launch script using the desired host
		Set oShell = CreateObject("WScript.Shell")
		Set objArgs = WScript.Arguments
		For I = 0 To objArgs.Count - 1	  
			args = args & " " & objArgs(I)	
		Next
		RunCmd = oShell.Run(comspec & " /k " & desiredhost & " """ & wscript.scriptfullname & """" & args, 1, True)
		WScript.Quit
	end if
End Sub